﻿
collaboflow.messages["general_settings_ajax_done"] = "設定内容を登録しました。";
collaboflow.messages["general_settings_ajax_fail"] = "設定の登録に失敗しました。";
collaboflow.messages["allowloginperiod_inputerror"] = "利用期間の終了日は、開始日以降の日付を入力して下さい。";
collaboflow.messages["enablemail_inputerror"] = "メール機能を有効にする場合、";
collaboflow.messages["smtpauth_inputerror"] = "SMTP認証を有効にする場合、";
collaboflow.messages["inputerror_not_natural_number"] = "1以上の整数を指定してください。";
collaboflow.messages["inputerror_negative_number"] = "0以上の整数を指定してください。";
collaboflow.messages["inputerror_comma"] = "カンマは指定できません。";
collaboflow.messages["ipaddresslimit_inputerror_ipaddress_invalid"] = "無効なIPアドレスです。";
collaboflow.messages["ipaddresslimit_inputerror_cidr_invalid"] = "CIDRには「1」～「32」ビットの数値を指定して下さい。";
collaboflow.messages["ipaddresslimit_inputerror_sameipaddress"] = "同一のIPアドレスが指定されています。";
collaboflow.messages["basicauth_inputerror"] = "BASIC認証を有効にする場合、";
collaboflow.messages["basicauth_inputerror_user_invalid"] = "BASIC認証の共通ユーザー名は半角英数字と「- + _ . @」のみ利用可能です。";
collaboflow.messages["basicauth_inputerror_password_invalid"] = "BASIC認証の共通パスワードは半角英数字と「- + _ . @」のみ利用可能です。";
collaboflow.messages["inputerror_required"] = "は入力必須です。";
collaboflow.messages["adauth_inputerror"] = "Active Directory認証を利用する場合、";
collaboflow.messages["cybozuopenauth_inputerror"] = "オープン統合認証 ver.2を利用する場合、";

const LOGO_IMAGE_NAME = ["Login", "Header", "Favicon"];
const LOGO_IMAGE_EXTENSION = ["gif", "jpg", "jpeg", "png"];
const FAVICON_IMAGE_EXTENSION = ["ico"];
const FAVICON_MAX_FILE_SIZE = 102400;
const FAVICON_SIZE = 48;
const LOGO_MAX_FILE_SIZE = 1048576;

function sanitizeInput(element) {
	const origin = $(element).val();
	const text = origin.replace(/<\/?script[^>]*>/gi, "");
	if (origin !== text) {
		$(element).val(text);
	}
}

// 初期化
$(document).ready(function(){

	cllForms = new collaboflow.form;
	cllForms.initialize("SettingsFormDef");
	cllForms.fillFormAll(collaboflow.data["GeneralSettings"]);

	var samlInfo = collaboflow.data["GeneralSettings"]["SAMLIDPCERTIFICATEINFO"];
	if(samlInfo) {
		$("#SamlIdpCertificateInfo").text(samlInfo);
	}

	$("#SystemTitle,#LoginAnnounce").on("blur", function () {
		sanitizeInput(this);
	});

	// トグルスイッチ化
	$("#enableMail").toggleSwitch({
		change: function(e) {
			changeEnableMail(e);
		}
	});
	$("#enableSMTP").toggleSwitch({
		change: function(e) {
			changeEnableSMTP(e);
		}
	});
	$("#enableGoogleOAuth").toggleSwitch({
		change: function(e) {
			changeEnableGoogleOAuth(e);
		}
	});

	$("#enableBasicAuth").toggleSwitch({
		change: changeBasicAuth
	});

	$("#enableSAML").toggleSwitch({
		change: changeenableSAML
	});

	$("#AdAuthSslSocket").toggleSwitch();
	$("#enableAdAuth").toggleSwitch({
		change: changeEnableAdAuth
	});

	$("#sslSocket").toggleSwitch();
	$("#tlsConnect").toggleSwitch();
	$("#enablePersonalInfoEdit").toggleSwitch();
	$("#enablePasswordReset").toggleSwitch();
	$("#bPW_Encryption").toggleSwitch();
	$("#enableCybozuOpenAuth2").toggleSwitch();

	listupRestClient(collaboflow.data["RestClients"]);

	changeIpAddressLimit();

	var loginLogoID = collaboflow.data["GeneralSettings"]["LOGINLOGO"];
	var headerLogoID = collaboflow.data["GeneralSettings"]["HEADERLOGO"];
	var faviconLogoID = collaboflow.data["GeneralSettings"]["FAVICONLOGO"];

	switchLogoImageEditor('Login' , loginLogoID != "" ? document.getElementById('LoginLogoPreview').src : "", true);
	switchLogoImageEditor('Header' , headerLogoID != "" ? document.getElementById('HeaderLogoPreview').src : "", true);
	switchLogoImageEditor('Favicon' , faviconLogoID != "" ? document.getElementById('FaviconLogoPreview').src : "", true);

	// カレンダー
	AllowLoginStart_Cal = new CLLCalendar('AllowLoginStart_Cal', 'AllowLoginStart_CalDiv', 'AllowLoginStart', 'AllowLoginStart_CalShim', 100);
	AllowLoginStart_Cal.tailFormat='';
	AllowLoginEnd_Cal = new CLLCalendar('AllowLoginEnd_Cal', 'AllowLoginEnd_CalDiv', 'AllowLoginEnd', 'AllowLoginEnd_CalShim', 100);
	AllowLoginEnd_Cal.tailFormat='';
});

// メール機能の有効化
changeEnableMail = function(e){

	if( $("#enableMail").val() == "true"){
		$("#MailServerName").prop("disabled", false);
		$("#AdminName").prop("disabled", false);
		$("#AdminMail").prop("disabled", false);
		$("#MailServerPort").prop("disabled", false);
		if( $("#enableSMTP").val() == "true"){
			$("#SMTPAuthUser").prop("disabled", false);
			$("#SMTPAuthPassword").prop("disabled", false);
			if( $("#enableGoogleOAuth").val() == "true"){
				$("#SMTPAuthPassword").prop("disabled", true);
			}
		}
	}
	else{
		$("#MailServerName").prop("disabled", true);
		$("#AdminName").prop("disabled", true);
		$("#AdminMail").prop("disabled", true);
		$("#MailServerPort").prop("disabled", true);
		$("#SMTPAuthUser").prop("disabled", true);
		$("#SMTPAuthPassword").prop("disabled", true);
	}
}

// SMTP認証の有効化
changeEnableSMTP = function(e){
	if( $("#enableSMTP").val() == "true" && $("#enableMail").val() == "true"){
		$("#SMTPAuthUser").prop("disabled", false);
		$("#SMTPAuthPassword").prop("disabled", false);
		if( $("#enableGoogleOAuth").val() == "true"){
			$("#SMTPAuthPassword").prop("disabled", true);
		}
	}
	else{
		$("#SMTPAuthUser").prop("disabled", true);
		$("#SMTPAuthPassword").prop("disabled", true);
	}
}

// SMTPのGoogleOAuth認証の有効化
changeEnableGoogleOAuth = function(e){
	if( $("#enableGoogleOAuth").val() == "true" && $("#enableSMTP").val() == "true" && $("#enableMail").val() == "true"){
		$("#SMTPAuthPassword").prop("disabled", true);
	}
	else if ($("#enableSMTP").val() == "true" && $("#enableMail").val() == "true"){
		$("#SMTPAuthPassword").prop("disabled", false);
	}
}

// BASIC認証の有効化
changeBasicAuth = function(e){
	var disabled = $("#enableBasicAuth").val() != "true";
	$("#BasicAuthUser,#BasicAuthPassword").prop("disabled", disabled);
}

// SAML認証の有効化トグル
changeenableSAML = function(e){
	var disabled = $("#enableSAML").val() != "true";
	$("input.saml-params,textarea.saml-params").prop("disabled", disabled);
}

// AD認証の有効化
changeEnableAdAuth = function(e){
	var disabled = $("#enableAdAuth").val() != "true";
	$("input.adauth-params,select.adauth-params").prop("disabled", disabled);
	changeEnableToggleSwitch("AdAuthSslSocket", disabled);
}

// トグル有効化の切り替え
changeEnableToggleSwitch = function(toggleId, disabled){
	var events = "auto";
	var color = "#ffffff";
	if(disabled){
		events = "none";
		color = "#eeeeee";
	}
	$("#" + toggleId).next("div").css({"pointer-events":events, "background-color":color});
}

// IPアドレス制限の切り替え
changeIpAddressLimit = function(e){
	var isDisplay = ($("#IpAddressLimitSettings").val() != "permit");

	$("#PermitIpList").toggle(isDisplay);
	$("#addPermitIpBtn").toggle(isDisplay);
	$("#PermitIpAnnotation").toggle(isDisplay);
}

// アプリケーション設定の保存
saveApplicationSettings = function(){
	var s;
	var permitIpRowIndex = "";
	var permitIpAddress = "";
	var permitIpCidr = "";
	var permitIpAndCidrList = [];
	var permitIpIdList = [];
	var permitIpError = false;

	// 入力チェック実施
	aValidateMess = cllForms.validateAll();
	if($("#AllowLoginStart").val().length && $("#AllowLoginEnd").val().length
		&& $("#AllowLoginStart").val() > $("#AllowLoginEnd").val() && !aValidateMess.length){
		aValidateMess.push(collaboflow.messages["allowloginperiod_inputerror"]);
	}
	if($("#enableMail").val() == "true"){
		if($("#MailServerName").val().length == 0){
			aValidateMess.push(collaboflow.messages["enablemail_inputerror"] + "利用メールサーバー" + collaboflow.messages["inputerror_required"]);
		}
		if($("#AdminName").val().length == 0){
			aValidateMess.push(collaboflow.messages["enablemail_inputerror"] + "管理メール送信元名" + collaboflow.messages["inputerror_required"]);
		}
		if($("#AdminMail").val().length == 0){
			aValidateMess.push(collaboflow.messages["enablemail_inputerror"] + "管理メール送信元アドレス" + collaboflow.messages["inputerror_required"]);
		}
		if($("#MailServerPort").val().length == 0){
			aValidateMess.push(collaboflow.messages["enablemail_inputerror"] + "サーバーポート" + collaboflow.messages["inputerror_required"]);
		}
	}
	if($("#enableSMTP").val() == "true" && $("#enableMail").val() == "true"){
		if($("#SMTPAuthUser").val().length == 0){
			aValidateMess.push(collaboflow.messages["smtpauth_inputerror"] + "SMTPユーザー名" + collaboflow.messages["inputerror_required"]);
		}
		if($("#SMTPAuthPassword").val().length == 0 && $("#enableGoogleOAuth").val() == "false"){
			aValidateMess.push(collaboflow.messages["smtpauth_inputerror"] + "SMTPパスワード" + collaboflow.messages["inputerror_required"]);
		}
	}
	const IdleTimeout = $("#IdleTimeout").val();
	if(IdleTimeout.length > 0){
		if (IdleTimeout < 0 || IdleTimeout.indexOf(".") != -1) {
			aValidateMess.push("認証有効期間は" + collaboflow.messages["inputerror_negative_number"]);
		}
		if (IdleTimeout.indexOf(",") != -1) {
			aValidateMess.push("認証有効期間に" + collaboflow.messages["inputerror_comma"]);
		}
	}


	const tryAuthLimitTerm = $("#TryAuthLimitTerm").val();
	if(tryAuthLimitTerm.length > 0){
		if (tryAuthLimitTerm <= 0 || tryAuthLimitTerm.indexOf(".") != -1) {
			aValidateMess.push("アカウントロックまでの期間は" + collaboflow.messages["inputerror_not_natural_number"]);
		}
		if (tryAuthLimitTerm.indexOf(",") != -1) {
			aValidateMess.push("アカウントロックまでの期間に" + collaboflow.messages["inputerror_comma"]);
		}
	}

	const tryAuthLimitTimes = $("#TryAuthLimitTimes").val();
	if(tryAuthLimitTimes.length > 0){
		if (tryAuthLimitTimes <= 0 || tryAuthLimitTimes.indexOf(".") != -1) {
			aValidateMess.push("アカウントロックされる回数は" + collaboflow.messages["inputerror_not_natural_number"]);
		}
		if (tryAuthLimitTimes.indexOf(",") != -1) {
			aValidateMess.push("アカウントロックされる回数に" + collaboflow.messages["inputerror_comma"]);
		}
	}

	if($("#enableBasicAuth").val() == "true"){
		s = $("#BasicAuthUser").val();
		if(s.length == 0){
			aValidateMess.push(collaboflow.messages["basicauth_inputerror"] + "共通ユーザー名" + collaboflow.messages["inputerror_required"]);
		}
		else if(!s.match(/^[a-zA-Z0-9-,+,_,.,@]+$/)) {
			aValidateMess.push(collaboflow.messages["basicauth_inputerror_user_invalid"]);
		}

		s = $("#BasicAuthPassword").val();
		if(s.length == 0){
			aValidateMess.push(collaboflow.messages["basicauth_inputerror"] + "共通パスワード" + collaboflow.messages["inputerror_required"]);
		}
		else if(!s.match(/^[a-zA-Z0-9-,+,_,.,@]+$/)) {
			aValidateMess.push(collaboflow.messages["basicauth_inputerror_password_invalid"]);
		}
	}

	if($("#enableAdAuth").val() == "true"){
		if($("#AdAuthServerName").val().length == 0){
			aValidateMess.push(collaboflow.messages["adauth_inputerror"] + "ADサーバー" + collaboflow.messages["inputerror_required"]);
		}
		if($("#AdAuthPort").val().length == 0){
			aValidateMess.push(collaboflow.messages["adauth_inputerror"] + "AD認証のポート" + collaboflow.messages["inputerror_required"]);
		}
		if($("#AdAuthDomainName").val().length == 0){
			aValidateMess.push(collaboflow.messages["adauth_inputerror"] + "ADのドメイン名" + collaboflow.messages["inputerror_required"]);
		}
		if($("#AdAuthBaseDN").val().length == 0){
			aValidateMess.push(collaboflow.messages["adauth_inputerror"] + "ベースDN" + collaboflow.messages["inputerror_required"]);
		}
	}

	if($("#enableCybozuOpenAuth2").val() == "true"){
		if($("#CybozuOpenAuth2Password").val().length == 0){
			aValidateMess.push(collaboflow.messages["cybozuopenauth_inputerror"] + "セッション認証の認証パスワード" + collaboflow.messages["inputerror_required"]);
		}
	}

	// IPアドレス制限チェック
	if($("#IpAddressLimitSettings").val() == "deny"){
		$("#PermitIpList tbody tr").each(function(rowNo) {
			if($(this).attr("id") == "PermitIpRowTemplate"){
				return;
			}

			permitIpRowIndex = $(this).attr("id").split("_")[1];
			permitIpAddress = $("#PermitIpAddress_" + permitIpRowIndex).val();
			permitIpCidr = $("#PermitIpCidr_" + permitIpRowIndex).val();
			permitIpAndCidr = permitIpAddress + "/" + permitIpCidr;

			// 必須チェック
			if(permitIpAddress.length == 0){
				aValidateMess.push("【" + rowNo + "行目】 IPアドレス" + collaboflow.messages["inputerror_required"]);
				permitIpError = true;
			}
			// IPアドレス有効性チェック
			else if(!permitIpAddress.match(/^(([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/)){
				aValidateMess.push("【" + rowNo + "行目】 " + collaboflow.messages["ipaddresslimit_inputerror_ipaddress_invalid"]);
				permitIpError = true;
			}

			// Cidr有効性チェック
			if(permitIpCidr.length > 0 && !permitIpCidr.match(/^([1-9]|1[0-9]|2[0-9]|3[0-2])$/)){
				aValidateMess.push("【" + rowNo + "行目】 " + collaboflow.messages["ipaddresslimit_inputerror_cidr_invalid"]);
				permitIpError = true;
			}

			// IPアドレス/Cidrの重複チェック
			if($.inArray(permitIpAndCidr,permitIpAndCidrList) >= 0 ){
				aValidateMess.push("【" + rowNo + "行目】 " + collaboflow.messages["ipaddresslimit_inputerror_sameipaddress"]);
				permitIpError = true;
			}

			// エラーがあった場合はチェック処理を抜ける
			if(permitIpError){
				return false;
			}

			// 行IDをリストに追加
			permitIpIdList.push(permitIpRowIndex);

			// IPアドレス/Cidrをリストに追加
			permitIpAndCidrList.push(permitIpAndCidr);
		});

		// 登録対象となる行IDをhiddenにセット
		if(permitIpError == false){
			$("#PermitIpIdList").val(permitIpIdList);
		}
	}

	if( aValidateMess.length > 0 ){
		outNoty("warning","top",aValidateMess.join("<br />"));
	}
	else{
		let settingsEditorForm = $("#SettingsEditorForm").get()[0];
		let settingsEditorFormData = new FormData(settingsEditorForm);

		$.ajax({
			type: "post",
			url: collaboflow.page.indexPath + "?fuseaction=admin_Settings&subaction=saveSettings",
			data: settingsEditorFormData,
			datatype: 'json',
			processData: false,
			contentType: false
		}).done(function(result) {
			var data = $.parseJSON(result);

			if(data.errorMessage !== "") {
				outNoty("warning","top",data.errorMessage);
				return;
			}

			if(data.bPermitAccessIp == false){
				outNoty("warning","top","現在アクセスしているIPアドレス「" + data.accessIp + "」を許可するIPアドレスに含める必要があります。");
				return;
			}

			cllForms.fillFormAll(data);

			var samlInfo = data["SAMLIDPCERTIFICATEINFO"];
			if(samlInfo) {
				$("#SamlIdpCertificateInfo").text(samlInfo);
			} else {
				$("#SamlIdpCertificateInfo").text("");
			}

			// 初期化しておく
			for(let logoImageIndex = 0; logoImageIndex < LOGO_IMAGE_NAME.length; logoImageIndex++) {
				const logoImageName = `${LOGO_IMAGE_NAME[logoImageIndex]}Logo`;
				$(`#${logoImageName}`).val("");
			}

			outNoty("success","top",collaboflow.messages["general_settings_ajax_done"]);
		}).fail(function() {
			alert(collaboflow.messages["general_settings_ajax_fail"]);
		});
	}
}

createRestClient = function() {
	var clientName = $("#NewRestClientName").val().trim();

	if(clientName.length == 0) {
		$("#NewRestClientName").focus();
		outNoty("warning","top","クライアント名は必須です。");
		return;
	}

	var is_conflict = false;
	$("#RestClientList tbody tr").each(function(index) {
		if($(this).data("client_name") == clientName) {
			is_conflict = true;
			return false;
		}
	});
	if(is_conflict) {
		outNoty("warning","top","同名のクライアントが登録済みです。");
		return;
	}

	var clientType = $("#NewRestClientType option:selected").val();
	if(clientType == "") {
		$("#NewRestClientType").focus();
		outNoty("warning","top","認証タイプを選択してください。");
		return;
	}

	var params = {
		client_type: clientType,
		client_name: clientName
	};

	$.ajax({
		type: "post",
		url: collaboflow.page.indexPath + "?fuseaction=admin_Settings&subaction=createRestClientApp",
		data: $.param(params),
		datatype: 'json'
	}).done(function(result) {
		// 登録できたら新規登録欄の名前は消しておく
		$("#NewRestClientName").val("");

		var data = $.parseJSON(result);
		listupRestClient(data);
	}).fail(function() {
		alert("クライアントの登録に失敗しました。");
	});
}

destroyRestClient = function(sender) {
	var clientId = $(sender).data("client_id");
	var clientName = $(sender).data("client_name");

	if(clientId === null || clientId.length == 0) {
		outNoty("warning","top","削除対象が未指定です。");
		return;
	}

	var ans = window.confirm(clientName + " を削除しますか？\n\n【注意】\nこのクライアントIDを利用しているアプリからのアクセスが無効化されます。\n");
	if(!ans) {
		return;
	}

	var params = {
		client_id: clientId
	};

	$.ajax({
		type: "post",
		url: collaboflow.page.indexPath + "?fuseaction=admin_Settings&subaction=destroyRestClientApp",
		data: $.param(params),
		datatype: 'json'
	}).done(function(result) {
		var data = $.parseJSON(result);
		listupRestClient(data);
		outNoty("success","top",clientName + " を削除しました。");
	}).fail(function() {
		alert("クライアントの削除に失敗しました。");
	});
}

listupRestClient = function(data) {
	//新しい一覧を作る
	var tbody = $("<tbody/>");
	for(var index in data) {
		var client = data[index];
		var row = $("<tr/>")
			.data("client_id", client.client_id)
			.data("client_name", client.client_name)
			.append($("<td/>").text(client.client_name))
			.append($("<td/>").text(client.client_id))
			.append($("<td/>").text(client.client_type_disp))
			.append($("<td/>").text(client.create_date))
			.append($('<td nowrap="nowrap"/>').append(
				$('<button type="button" class="btn-M" onclick="destroyRestClient(this.parentNode.parentNode)">削除</button>')
			));
		tbody.append(row);
	}
	//古い一覧と新しい一覧を挿げ替える
	$("#RestClientList tbody").remove();
	$("#RestClientList").append(tbody);
}

// 許可IPアドレスの行追加
addPermitIpRow = function() {
	var maxRowId = 0;
	var baseId = "";

	if($("#PermitIpList tbody tr").length > 100){
		alert("登録できるIPアドレスは100個までです。");
		return;
	}

	// 最終行の行IDを取得
	if($("#PermitIpList tbody").children().length > 1){
		maxRowId = $("#PermitIpList tr:last").attr("id").split("_")[1];
	}

	var newRowId = parseInt(maxRowId) + 1;

	// 追加行用のクローンを生成
	var newRows = $("#PermitIpRowTemplate").clone(true).attr("id","PermitIpRow_" + newRowId);

	// 追加行のid、name付与
	newRows.find("input").each(function(i) {
		baseId = $(this).attr("id");
		$(this).attr("id",baseId + "_" + newRowId).attr("name",baseId + "_" + newRowId);
	});

	// 行を追加
	newRows.appendTo("#PermitIpList").show();
}

// 許可IPアドレスの行削除
removePermitIpRow = function(objButton) {
	var removeRow = objButton.parentNode.parentNode;
	$(removeRow).remove();
}

// TOPに戻る
returnToTop = function(){
	window.location.href = collaboflow.page.uri + "&fuseaction=admin";
}

$("#LoginLogoUpdate,#HeaderLogoUpdate,#FaviconLogoUpdate").on("change", function() {
	const filename = $(this).val().replace(/.+[\/\\]/, "");
	const jqFile = $(this);
	const targetId = this.id.replace("LogoUpdate","");

	if(jqFile.length === 0) {
		return;
	}

	const fileParts = jqFile[0];
	if(fileParts.files.length === 0) {
		return;
	}

	if (filename.match(/[\\\/:*?"<>|\t"]/)) {
		updateParts(false, '');
		outNoty("warning", "topCenter", 'ファイル名に「\\」「/」「:」「*」「?」「"」「<」「>」「|」「タブ文字」<br>が含まれているためアップロードできません');
		return;
	}

	outProgressBar();

	const reader = new FileReader();
	reader.onload = (event) => {
		const base64Text = event.currentTarget.result;
		switchLogoImageEditor(targetId, base64Text);
	}

	reader.readAsDataURL(fileParts.files[0]);

	hideProgressBar();
});

switchLogoImageEditor = async function(targetId, base64DataString, isInitialize=false) {
	const logoImageName = `${targetId}Logo`;

	const logoImage = document.getElementById(logoImageName);
	const logoImageFileName = document.getElementById(`${logoImageName}FileName`);
	const logoImageView = document.getElementById(`${logoImageName}View`);
	const logoImageEdit = document.getElementById(`${logoImageName}Edit`);
	const logoImagePreview = document.getElementById(`${logoImageName}Preview`);
	const logoImageFile = document.getElementById(`${logoImageName}Update`);

	if (base64DataString.length) {
		if(!isInitialize && !await validateLogoImage(logoImageName)) {
			logoImageFile.value = "";
			return;
		}

		if(logoImageFile.value) {
			const fileName = logoImageFile.files[0].name;
			logoImageFileName.value = fileName;
		}

		logoImagePreview.src = base64DataString;
		logoImageView.style.display = 'flex';
		logoImageView.style.alignItems = 'center';
		logoImageEdit.style.display = 'none';
	} else {
		logoImage.value = "";
		logoImageFile.value = "";
		logoImageFileName.value = "";
		logoImagePreview.src = "";
		logoImageView.style.display = 'none';
		logoImageEdit.style.display = 'block';
	}

	if(!isInitialize) {
		logoImage.value = 1;
	}
}

async function validateLogoImage(targetId) {
	const logoImageFile = document.getElementById(`${targetId}Update`);

	const logoImageFileData = logoImageFile.files[0];
	const extension = logoImageFileData.name.split('.').pop();

	switch(targetId) {
		case "FaviconLogo":
			if(!checkLogoImageExtension(extension, FAVICON_IMAGE_EXTENSION)) {
				return false;
			}

			if(!checkLogoImageFileSize(logoImageFileData.size, FAVICON_MAX_FILE_SIZE)) {
				return false;
			}

			if(!await checkLogoImageSize(logoImageFileData, FAVICON_SIZE, FAVICON_SIZE)) {
				return false;
			}
		break;

		case "LoginLogo":
		case "HeaderLogo":
			if(!checkLogoImageExtension(extension, LOGO_IMAGE_EXTENSION)) {
				return false;
			}

			if(!checkLogoImageFileSize(logoImageFileData.size, LOGO_MAX_FILE_SIZE)) {
				return false;
			}
		break;
	}

	return true;
}

function checkLogoImageExtension(targetExtension, extensionList) {
	if(!extensionList.includes(targetExtension)) {
		const extensionMessage = extensionList.join("、");
		outNoty("warning","top",`アップロード可能な拡張子は「${extensionMessage}」のみです。`);
		return false;
	}

	return true;
}

function checkLogoImageFileSize(targetFileSize, maxFileSize) {
	if(maxFileSize <= targetFileSize) {
		const fileSizeMessage = (maxFileSize === 1048576) ? "1MB" : "100KB";
		outNoty("warning","top",`アップロード可能なファイルサイズ（${fileSizeMessage}）を超えています。`);
		return false;
	}

	return true;
}

async function checkLogoImageSize(targetFile, baseWidth, baseHeight) {
	const imageSize = await getLogoImageSize(targetFile);

	const isRegisterableWidth = baseWidth === imageSize.width;
	const isRegisterableHeight = baseHeight === imageSize.height;

	if(!isRegisterableWidth || !isRegisterableHeight) {
		outNoty("warning","top",`アップロード可能な画像サイズは「${baseWidth}px × ${baseHeight}px」のみです。`);
		return false;
	}

	return true;
}

function getLogoImageSize(targetFile) {
	return new Promise((resolve, reject) => {
		const img = new Image();

		img.onload = () => {
			const size = {
			width: img.naturalWidth,
			height: img.naturalHeight,
		};

			URL.revokeObjectURL(img.src);
			resolve(size);
		};

		img.onerror = (error) => {
			reject(error);
		};

		img.src = URL.createObjectURL(targetFile);
	});
}
